#include <stdio.h>
#include "control/kmodules_loader.h"
#include "util/logger.h"
#include "global_types.h"

static void print_modules_loader_error_message(error_code_t err);

static void print_modules_loader_error_message(error_code_t err)
{
  if (err==RESULT_NORESOURCES)
	  logger_log_error("Out of memory or something else very strange.");
  if (err==RESULT_TIMEOUT_EXPIRED)
	  logger_log_error("Timeout expired.");
}

int main(int argc, char* argv[])
{
  error_code_t result;
  int ret_val=0;

  result=kmodules_loader_init(argc,argv);
  if (result==RESULT_OK)
    result=kmodules_loader_start();

  if (result!=RESULT_OK)
  {
	  print_modules_loader_error_message(result);
	  if (result==RESULT_HELP_PRINTED)
		  ret_val=1;
	  else
		  ret_val=2;
  }

  kmodules_loader_deinit(result==RESULT_TIMEOUT_EXPIRED);
  return ret_val;
}
